-------------- REQUTES DE BASES - (38 exercices...)

-- il dit sur quelle base de donnes on travaille. Il change la base par dfaut.
use AdventureWorksDW2022

-- permet de savoir le temps d'excution d'une requte.
set statistics time on
-- permet de vider le cache (lieu de stockage des donnes)
DBCC FREEPROCCACHE
-- dbcc dropcleanbuffers

-- A. Affichage des colonnes et des lignes 
-- A.1 Je souhaite afficher toutes les colonnes de la table dimcustomer
-- Rsultats : 18484 lignes
Select *
From dimcustomer

-- A.2 Je souhaite afficher toutes les colonnes mais que pour les 100 premires lignes
Select top 100 *
From dimcustomer

-- A.3 Je souhaite afficher les 75 premires lignes mais que la colonne emailaddress
Select top 75 EmailAddress
From dimcustomer

-- A.4 Je souhaite afficher les 50 premires lignes mais que les colonnes emailaddress et commuteDistance
Select top 50 EmailAddress , CommuteDistance
From dimcustomer

-- B.1 Afficher les frencheducation des clients
-- Rsultat : 5 niveaux d'tudes diffrents
Select distinct frencheducation
From dimcustomer

-- B.2 Afficher les frencheducation et frenchoccupation des clients
-- Rsultat : 25 lignes
Select distinct frencheducation, FrenchOccupation
From dimcustomer

------ Exos en plus, si vous avez de l'avance sur le groupe :
-- B3. Afficher les 1000 premiers clients (prenom, nom, birthdate, yearlyincome, totalchildren)
select 1000 firstname, lastname, BirthDate, yearlyincome, totalchildren
From dimcustomer

-- B4. Afficher les diffrents types de salaire (yearlyincome) des clients
-- Rsultats : 16
Select distinct yearlyincome
From dimcustomer

-- B5. Afficher les diffrents types de salaire (yearlyincome) des clients 
-- ainsi que la colonne sui permet de savoir s'ils sont propritaires d'une maison (houseownerflag)
-- Rsultats : 32 (concatnations de yearlyincome et houseownerflag diffrents)
Select distinct yearlyincome, HouseOwnerFlag
From dimcustomer

--------------------------------------------------------------------------------------------------------------------
-- C.1 Afficher et renommer la colonne lastname en "nom" 
Select lastname as nom
From dimcustomer

-- C.2 Afficher et renommer en plus, la colonne firstname en "prnom du client"
Select lastname as nom,
	   firstname as 'prnom du client'
From dimcustomer

-- C.3 Afficher et renommer en plus, la colonne emailaddress en "L'adresse email"
Select lastname as nom,
	   firstname as 'prnom du client',
	   EmailAddress as 'L''email du client'
From dimcustomer

-- D.1 Mme requte que C3 mais avec ajout d'un tri ascendant sur le nom de famille
Select lastname as nom,
	   firstname as 'prnom du client',
	   EmailAddress as 'L''email du client'
From dimcustomer
order by lastname asc

-- D.2 Mme requte que D1 mais avec ajout d'un tri descendant sur le prnom
Select lastname as nom,
	   firstname as 'prnom du client',
	   EmailAddress as 'L''email du client'
From dimcustomer
order by lastname, firstname desc

------ Exos en plus - si vous avez de l'avance sur le groupe : 
-- D.3 : copier/coller le B3 et supprimer le TOP1000 // 
-- Si vous ne l'aviez pas fait, voici la requte sur laquelle repartir :
select firstname, lastname, BirthDate, yearlyincome, totalchildren
From dimcustomer
-- Renommer les colonnes avec nom en franais (prnom, nom, date de naissance, salaire, nombre d'enfants)
select firstname as prenom, lastname as nom, BirthDate as 'date de naissance', 
		yearlyincome as salaire, totalchildren as 'nombre d''enfants'
From dimcustomer

-- D.4 : trier les rsultats du D3 par ordre dcroissant sur le yearlyincome, 
-- puis sur le totalchildren par ordre dcroissant
-- puis sur la date de naissance par ordre croissant
select firstname as prenom, lastname as nom, BirthDate as 'date de naissance', 
		yearlyincome as salaire, totalchildren as 'nombre d''enfants'
From dimcustomer
-- order by yearlyincome desc, TotalChildren desc, BirthDate asc
order by salaire desc, [nombre d'enfants] desc, [date de naissance] asc
-- order by 4 desc, 5 desc, 3 asc

-------------------------------------------------------------------------------------------------------------------
-- E.1 Afficher seulement les lignes correspondantes aux clients
-- qui sont des hommes (M dans gender) et qui sont maris (M dans marital status)
-- rsultat : 5266
select * from Dimcustomer

select *
from Dimcustomer
where gender = 'M' and MaritalStatus ='M'

-- E.2 Pareil que la E.1 mais avec une condition en plus
-- Quand le yearlyincome est suprieur  60000
-- rsultat : 2026
select *
from Dimcustomer
where gender = 'M' and MaritalStatus ='M' 
and yearlyincome > 60000

-- E.3 Pareil que la E.2 mais avec une condition en plus
-- quand la date de naissance est suprieure ou gale au 01 janvier 1980
-- rsultat : 179
select *
from Dimcustomer
where gender = 'M' and MaritalStatus ='M' 
and yearlyincome > 60000 and birthdate >= '01/01/1980' -- ou year(birthdate >= 1980

-- E.4 Pareil que la E.3 mais avec une condition en plus
-- Quand le prnom du client n'est pas jonathan
-- Trier par ordre alphabtique les prnoms
-- rsultat : 176
select *
from Dimcustomer
where gender = 'M' and MaritalStatus ='M' 
and yearlyincome > 60000 and birthdate >= '01/01/1980'
and firstname <> 'Jonathan'
order by firstname

------ E.4 Bis Exos en plus si vous avez de l'avance sur le groupe
-- E.4.b Nouvelle requte : Je souhaite les femmes, cadres (frenchoccupation)
-- qui n'ont pas le niveau d'tude bac + 4 (frencheducation)
-- qui sont propritaires de 3 voitures ou plus (numbercarsowned)
-- Rsultats : 423
select *
from Dimcustomer
where gender = 'f' and FrenchOccupation = 'cadre'
	and FrenchEducation <> 'Bac + 4'
	and NumberCarsOwned >= 3

-- E.4.c Reprendre le E.4.b
-- Je souhaite afficher leur prnom, leur nom, leur date de naissance, leur situation familiale (maritalstatus) et leur salaire (yearlyincome)
-- Rsultats : 423
select firstname, lastname, birthdate, MaritalStatus, yearlyincome
from Dimcustomer
where gender = 'f' and FrenchOccupation = 'cadre'
	and FrenchEducation <> 'Bac + 4'
	and NumberCarsOwned >= 3

-- E.4.d Reprendre le E.4.c
-- Renommer yearlyincome en salaire et date de naissance galement
-- trier par salaire dcroissant puis par date de naissance dcroissant
-- afficher que les 5 premiers rsultats de cette requte :)
-- Rsultats : 423
select top 5 firstname, lastname, birthdate as 'date de naissance', MaritalStatus, yearlyincome as salaire
from Dimcustomer
where gender = 'f' and FrenchOccupation = 'cadre'
	and FrenchEducation <> 'Bac + 4'
	and NumberCarsOwned >= 3
Order by YearlyIncome desc, birthdate desc

----------------------------------------------------------------------------------------------------
-- E.5 Afficher seulement les lignes correspondantes aux clients
-- qui ont un niveau d'tude soit Bac + 4 soit bac + 3 (attention aux espaces avant et aprs le +)
-- Rsultat : 8 545
select *
From dimcustomer
where FrenchEducation in ('Bac + 4', 'Bac + 3')

-- E.6 Pareil que E.5 mais avec nouvelle condition
-- Clients qui ne sont ni ouvriers ni employs (vrifier les donnes dans la table, il n'y a peut-tre pas de s ou autres)
-- Rsultat : 7 277
select *
From dimcustomer
where FrenchEducation in ('Bac + 4', 'Bac + 3')
and frenchoccupation not in ('Employ','Ouvrier')

------ E.6 bis Exos en plus si vous avez de l'avance sur le groupe
-- E.6.b Nouvelle requte : Je souhaite les clients qui ont 2 ou 3 enfants (totalchildren)
-- Rsultats : 5973
Select *
From dimcustomer
where TotalChildren in (2,3)

-- E.6.c Reprendre E.6.b : 
-- Je souhaite rajouter ceux qui n'ont pas 1 ou 2 voitures (numbercarsowned)
-- Rsultats : 1793
Select *
From dimcustomer
where TotalChildren in (2,3)
 and NumberCarsOwned not in (1,2)

-- E.6.d Reprendre E.6.c : 
-- Je souhaite rajouter ceux qui ont comme nom de famille Alvarez, Baker, Bennett, Yang et Lee
-- Rsultats : 41
Select *
From dimcustomer
where TotalChildren in (2,3)
 and NumberCarsOwned not in (1,2)
 and lastname IN ('Alvarez', 'Baker', 'Bennett', 'Yang' , 'Lee')

-------------------------------------------------------------------------------------------------------------------------------
-- E.7 Afficher seulement les lignes correspondantes aux clients
-- dont la frencheducation contient un +
-- Rsultat : 11839
select *
From dimcustomer
where FrenchEducation like '%+%'

-- E.8 Pareil que E.7 mais avec condition en plus
-- Clients dont leur prnom ne commence pas par Je
-- Rsultat : 11524
select *
From dimcustomer
where FrenchEducation like '%+%'
and firstname not like 'Je%'

------ E.8 bis Exos en plus si vous avez de l'avance sur le groupe
-- E.8.b Nouvelle requte : Je souhaite les clients dont leur englisheducation contient partial en dbut de valeur
-- Rsultats : 6645
select *
From dimcustomer
where englishEducation like 'partial%'

-- E.8.c Reprendre E.8.b avec condition en plus :
-- Je souhaite uniquement les clients dont l'adresse contient DR (addressline1)
-- Rsultats : 1316
select *
From dimcustomer
where englishEducation like 'partial%'
 and AddressLine1 like '%dr%'
--------------------------------------------------------------------------------------------------------------------------------
-- E.9 Afficher les noms des clients
-- quand ils sont ns entre 1970 et 1979 inclus (utiliser la fonction year() )
-- Rsultat : 6353
select lastname, firstname, datediff(year, birthdate, getdate()) as 'ge client'
From dimcustomer
where year(birthdate) between 1970 and 1979
-- where birthdate between '1970-01-01' and '1979-12-31'

-- E.10 Pareil que E.9 mais avec condition en plus
-- Les clients qui ont entre 2 et 4 enfants (2 et 4 inclus : colonne totalchildren)
-- Rsultat : 2082
select lastname, firstname,totalchildren, datediff(year, birthdate, getdate()) as 'ge client'
From dimcustomer
where year(birthdate) between 1970 and 1979
-- birthdate between '1970-01-01' and '1979-12-31'
and totalchildren between 2 and 4

-- E.11 Pareil que E.10 mais avec condition en plus
-- Quand la colonne middleName est renseigne
-- Rsultat : 1211
select *
From dimcustomer
where birthdate between '1970-01-01' and '1979-12-31'
and totalchildren between 2 and 4
and middlename is not null

------ Exos en plus si vous avez de l'avance sur le groupe
-- E.12 Exercice en plus pour ceux bien avancs
-- Je souhaite les hommes maris
-- qui ont entre 1 et 3 enfants
-- dont le salaire est suprieur ou gal  50000
-- dont la frencheducation ne contient pas le mot niveau
-- dont le frenchoccupation est cadre ou technicien
-- quand la date du premier achat (datefirstpurchase) est entre 2012 et 2013 inclus
-- Rsultat : 999 lignes
select *
From dimcustomer
where MaritalStatus ='M' and gender ='M'
and totalchildren between 1 and 3
and yearlyincome >= 50000
and FrenchEducation not like '%niveau%'
and FrenchOccupation IN ('Cadre','Technicien')
and year(datefirstpurchase) between 2012 and 2013

-- E.13 Je souhaite afficher les lignes clients correspondantes  deux profils diffrents :
-- ceux qui ont seulement le niveau bac (valeur "baccalaurat")(frencheducation) et qui sont  5-10 miles du travail (commutedistance)
-- ainsi que ceux qui sont bac + 4 et qui sont  1-2 miles
-- Rsultat : 1706
select *
From dimcustomer
where (FrenchEducation = 'Baccalaurat' and CommuteDistance = '5-10 Miles')
 or (FrenchEducation = 'Bac + 4' and CommuteDistance = '1-2 Miles')

 -- deux profils spars
select * -- 1155
From dimcustomer
where FrenchEducation = 'Baccalaurat' and CommuteDistance = '5-10 Miles'

select * -- 551
From dimcustomer
where FrenchEducation = 'Bac + 4' and CommuteDistance = '1-2 Miles'

---------------------------------------------------------------------------------------------------------------------
-- F.1 Compter le nombre de clients par frencheducation et frenchoccupation
-- PUis trier par frencheducation (asc) et nombre de clients (desc)
-- Rsultat : 25 
select FrenchEducation, FrenchOccupation, 
		count(CustomerKey) as 'nombre de clients'
From dimcustomer
group by FrenchEducation, FrenchOccupation
order by FrenchEducation, [nombre de clients] desc

-- F.2 Compter le nombre de clients par gender et maritalstatus
-- PUis trier par gender (asc) et maritalstatus (asc)
-- Rsultat : 4
select gender, MaritalStatus,
	count(CustomerKey) as 'nombre de clients'
From dimcustomer
group by gender, MaritalStatus
order by gender, MaritalStatus

------ Exos en plus si vous avez de l'avance sur le groupe
-- F.3 : Sur la table DIMRESELLER (les revendeurs qui vendent les produits de notre entreprise)
-- je souhaite compter le nombre de revendeurs
-- par banque et nombre d'employs (colonnes bankname et numberemployees)
-- puis trier par banque (asc) et nombre d'employs desc
-- Rsultats : 494
Select bankname, NumberEmployees, 
		count(ResellerKey) as 'nombre de revendeurs'
From Dimreseller
group by bankname, NumberEmployees
order by bankname, NumberEmployees desc

-- F.4 : Sur la table DIMRESELLER (les revendeurs qui vendent les produits de notre entreprise)
-- je souhaite compter le nombre de revendeurs
-- par type de business et ligne de produit (colonnes businesstype et productline)
-- trier par productline asc puis par nombre de revendeurs desc
-- Rsultats : 9
Select BusinessType, ProductLine, 
		count(ResellerKey) as 'nombre de revendeurs'
From Dimreseller
group by BusinessType, ProductLine
order by ProductLine asc, [nombre de revendeurs] desc

---------------------------------------------------------------------------------------------------------------------
-- G.1 Repartir sur requte du F.1 puis conditions en plus
-- Seulement pour les clientes
-- Quand le nombre de clientes est infrieur  100
-- Rsultat : 6
select FrenchEducation, FrenchOccupation, 
		count(CustomerKey) as 'nombre de clients'
From dimcustomer
where gender = 'F'
group by FrenchEducation, FrenchOccupation
having count(CustomerKey) < 100
order by FrenchEducation, [nombre de clients] desc

-- G.2 Repartir sur requte du F.2 puis conditions en plus
-- quand le salaire est suprieur ou gal  40000
-- et quand le nombre de clients est suprieur  3000
-- Rsultat : 2
select gender, MaritalStatus,
	count(CustomerKey) as 'nombre de clients'
From dimcustomer
where YearlyIncome > = 40000
group by gender, MaritalStatus
having count(CustomerKey) > 3000

-- G.3 Dcouvrir la table FactInternetSales
-- Compter le nombre de lignes (*)
-- et calculer la somme des ventes (salesamount = fonction sum)
-- par anne et par mois de vente (orderdate)
-- trier par ordre dcroissant les annes puis les mois (ascendant)
-- Rsultat : 38
Select year(orderdate) as anne, month(orderdate) as mois,
		count(*) as 'nombre de lignes',
		sum(salesamount) as 'somme des ventes'
from FactInternetSales
group by year(orderdate), month(orderdate)
order by anne desc, mois 

-- G.4 Reprendre G.3 mais avec conditions en plus
-- quand l'unitprice est entre 500 et 3000
-- et que le numro de produit est soit 320, 326, 330, 338 , 342
-- que le nombre de lignes est suprieur  8
-- que la somme des ventes est entre 6990,982 et 8389,1784
-- Rsultat : 5
Select year(orderdate) as anne, month(orderdate) as mois,
		count(*) as 'nombre de lignes',
		sum(salesamount) as 'somme des ventes'
from FactInternetSales
where UnitPrice between 500 and 3000
and productkey in (320, 326, 330, 338 , 342)
group by year(orderdate), month(orderdate)
having count(*) > 8 and
	sum(salesamount) between 6990.982 and 8389.1784
order by anne desc, mois

------ Exos en plus si vous avez de l'avance sur le groupe
-- G.5, reprendre la requte F.3.
-- Si vous ne l'aviez pas faite, voici son rsultat  rcuprer pour pouvoir faire l'exercice G.5 :
Select bankname, NumberEmployees, 
		count(ResellerKey) as 'nombre de revendeurs'
From Dimreseller
group by bankname, NumberEmployees
order by bankname, NumberEmployees desc

-- Enonc G.5 : On souhaite filtrer le rsultat
-- sur les banques ayant le mot international  l'intrieur = International Bank, International Security, Primary International
-- Puis filtrer sur le rsultat, quand le nombre de revendeurs est gal ou suprieur  3
-- Rsultats : 23
Select bankname, NumberEmployees, 
		count(ResellerKey) as 'nombre de revendeurs'
From Dimreseller
where bankname like '%international%'
group by bankname, NumberEmployees
Having count(ResellerKey) >= 3
order by bankname, NumberEmployees desc

-- G.6, reprendre la requte F.4 
-- Si vous ne l'aviez pas faite, voici son rsultat  rcuprer pour pouvoir faire l'exercice G.6 :
Select BusinessType, ProductLine, 
		count(ResellerKey) as 'nombre de revendeurs'
From Dimreseller
group by BusinessType, ProductLine
order by ProductLine asc, [nombre de revendeurs] desc

-- Enonc G.6 : On souhaite filtrer le rsultat
-- sur les reseller ayant un revenu annuel (annualrevenue) infrieur ou gal  100000
-- Et dont le nombre de revendeurs est gal ou suprieur  80
-- Rsultats : 2
Select BusinessType, ProductLine, 
		count(ResellerKey) as 'nombre de revendeurs'
From Dimreseller
where AnnualRevenue <= 100000
group by BusinessType, ProductLine
Having count(ResellerKey) >= 80
order by ProductLine asc, [nombre de revendeurs] desc

----------------------------------------------------------------------------------------------------------------------
-- H.1 Sur la table dimcustomer
-- Crer une nouvelle colonne qui indique le type de famille du client
-- si pas d'enfants alors 'pas d'enfants', si moins de 3 enfants 'famille moyenne', si plus 'famille nombreuse'
-- Rsultat : 18484
select lastname, firstname,
	case
		when totalchildren = 0 then 'pas d''enfants'
		when totalchildren < 3 then 'famille moyenne'
		else 'famille nombreuse'
	end as 'type de famille'
from dimcustomer

-- H.2 Pareil que pour H.1
-- Mais il faut compter le nombre de clients par type de famille
-- Rsultat : 3
select count(customerkey) as 'nombre de clients',
	case
		when totalchildren = 0 then 'pas d''enfants'
		when totalchildren < 3 then 'famille moyenne'
		else 'famille nombreuse'
	end as 'type de famille'
from dimcustomer
group by case
		when totalchildren = 0 then 'pas d''enfants'
		when totalchildren < 3 then 'famille moyenne'
		else 'famille nombreuse'
	end

-- H.3 Nombre de clients par tranche d'ge
-- Crer les tranches d'ges : moins de 40 ans 'jeunes', moins de 60 'matures', moins de 80 'sages', plus ou gal  80 'vieux'
-- trier par nombre de clients (ordre descendant)
-- Rsultat : 4 lignes
select count(customerkey) as 'nombre de clients',
	case
		when datediff(year, birthdate, getdate())  < 40 then 'jeunes'
		when datediff(year, birthdate, getdate())  < 60 then 'matures'
		when datediff(year, birthdate, getdate())  < 80 then 'sages'
		when datediff(year, birthdate, getdate())  >= 80 then 'vieux'
		else 'ge non connu'
	end as 'tranche d''ge'
from dimcustomer
group by case
		when datediff(year, birthdate, getdate())  < 40 then 'jeunes'
		when datediff(year, birthdate, getdate())  < 60 then 'matures'
		when datediff(year, birthdate, getdate())  < 80 then 'sages'
		when datediff(year, birthdate, getdate())  >= 80 then 'vieux'
		else 'ge non connu'
	end
order by [nombre de clients] desc

---------------------------------------------------------------------------------------------
-- I.1 Sur la table FactInternetSales
-- Je souhaite afficher la somme des ventes (salesamount), 
-- la moyenne des taxes (taxamt), 
-- le fret minimum (freight) 
-- et le prix max  l'unit (unitprice) pour toutes commandes confondues
-- Rsultat : 1
select sum(salesamount) as 'somme des ventes',
		avg(taxamt) as 'taxe moyenne',
		min(freight) as 'fret min',
		max(unitprice) as 'prix max  l''unit'
From FactInternetSales

-- I.2 Pareil que le I.1 
-- Mmes calculs mais PAR anne, par trimestre et par mois d'ordre de commande (orderdate)
-- Rsultat : 38
select year(OrderDate) as anne, 
		datepart("Quarter",orderdate) as trimestre,
		month(orderdate) as mois,
		sum(salesamount) as 'somme des ventes',
		avg(taxamt) as 'taxe moyenne',
		min(freight) as 'fret min',
		max(unitprice) as 'prix max  l''unit'
From FactInternetSales
group by year(OrderDate), datepart("Quarter",orderdate),month(orderdate)

-- I.3 Pareil que le I.2 mais avec conditions et tris
-- quand la taxe moyenne est infrieur  200
-- quand le cot total de production (totalproductcost) est suprieur  500
-- quand le jour d'envoi est entre le 10 et le 20 du mois
-- quand le fret min est entre 28 et 85
-- puis trier par somme des ventes descendant
-- Rsultat : 12
select year(OrderDate) as anne, datepart("Quarter",orderdate) as trimestre, month(orderdate) as mois,
		sum(salesamount) as 'somme des ventes',avg(taxamt) as 'taxe moyenne',
		min(freight) as 'fret min',max(unitprice) as 'prix max  l''unit'
From FactInternetSales
where totalproductcost > 500 and day(ShipDate) between 10 and 20
group by year(OrderDate), datepart("Quarter",orderdate),month(orderdate)
having min(freight) between 28 and 85 and avg(taxamt) < 200
order by [somme des ventes] desc

-- I.4 Nouvelle requte : Compter le nombre de produits diffrents vendus
-- Rsultat : 158 (et non pas 60398 qui correspond au nombre de commandes)
Select count(distinct productkey) as 'nombre produits diffrents'
from FactInternetSales

------ Exo en plus : 
-- I.5 Sur la table clients (dimcustomer)
-- Afficher seulement les 3 dernieres caractres du customeralternativekey
-- Puis les deux premires lettres de englishoccupation
-- Puis dans la colonne customeralternativekey :  partir du 6me caractre, prendre 2 caractres
-- Afficher le nom entirement en majuscule
-- Afficher la colonne frencheducation et supprimer espaces avant et aprs la valeur
-- Rsultat : 18 484
select right(CustomerAlternateKey,3) as '3 dernires lettres CAK',
	substring(CustomerAlternateKey,6,2) as 'extrait',
	left(englishoccupation,2) as '2 premires lettres EO',
	upper(lastname) as 'nom majuscule',
trim(frencheducation) as 'sans espaces avant et aprs'
From dimcustomer

-- I.6 Sur la table FactResellerSales -- Attention au nom de la table, contient bien Reseller  l'intrieur :)
-- Calculer le nombre de commandes et le nombre de revendeurs diffrents ayant particip  ces commandes
-- rsultats : 3796 pour les commandes et 635 pour les revendeurs
Select count(distinct SalesOrderNumber) as 'nombre de commandes',
		Count(distinct ResellerKey) as 'nombre de revendeurs'
From FactResellerSales

-- I.7 : Suite du I.6
-- Je souhaite regrouper par quantit commande (orderquantity)
-- Afficher en premier la colonne des quantits commandes
-- Filtrer sur l'anne de commande 2013 (orderdate)
-- Filtrer uniquement quand le nombre de commandes est suprieur ou gale  10
-- et que le nombre de revendeurs est suprieur  100
-- Puis trier par quantit vendue dcroissant
-- rsultats : 10 lignes
Select OrderQuantity as 'quantit vendue',
		count(distinct SalesOrderNumber) as 'nombre de commandes',
		Count(distinct ResellerKey) as 'nombre de revendeurs'
From FactResellerSales
where year(orderdate) = 2013
Group by OrderQuantity
having count(distinct SalesOrderNumber)  >= 10 and Count(distinct ResellerKey) > 100
order by OrderQuantity desc

-- I.8 Conversion sur la table Factinternetsales
-- afficher la datekey en format date
-- afficher la colonne date (format de base datetime) en format date
-- Rsultat : 60 398
Select convert(date,convert(char(8), orderdatekey)) as 'date int convertie en date',
		orderdate as 'date datetime',
		convert(date, orderdate) as 'date format date'
From Factinternetsales

